function [sigma_breve,y] = ...
    fault_slip_sigma_breve_2(ddelta_dxi,G,n_pt_y,nu,xi,y_max,y_min)
%
% Computes the shear stresses for y_min < y < y_max as a result of fault slip per unit length
% ddelta_dxi over a given interval which is spanned by a vector of integration points xi.   

% Compute auxiliary variables:
A = G / (2*pi*(1-nu));
if y_max == y_min % input given as scalar or vector
    y = y_max; 
else % input given as minimum and maximum values
    y = linspace(y_min,y_max,n_pt_y); 
end

% Interpolate dxi and ddelta_dxi values such that they coincide with midpoints of y:
y_mid = (y(1:end-1) + y(2:end))/2; % mid point y values 
xi_int = nonzeros( y_mid .* (xi(1) < y_mid) .* (y_mid < xi(end)) )'; % cropped such that ...
    % xi(1) < x_int < xi(end) 
ddelta_dxi_int = interp1(xi,ddelta_dxi,xi_int); % new ddelta_dxi values

% Compute slip-induced shear stress: (Note: vectorized formulation; see triple commented text
% below for version without vectorization.)
sigma_breve =  A * trapz(xi_int,ddelta_dxi_int ./ (y'-xi_int),2)';

% sigma_breve =  A * trapz(ddelta_dxi .* dxi ./ (y'-xi),2)'; % obsolete since 20201101

% % % n_y = length(y);
% % % sigma_breve = zeros(1,n_y);
% % % for i = 1:n_y
% % %     sigma_breve(i) = A * trapz(ddelta_dxi .* dxi ./ (y(i)-xi));
% % % end

